import { Switch, Route } from "wouter";
import { queryClient } from "./lib/queryClient";
import { QueryClientProvider } from "@tanstack/react-query";
import { Toaster } from "@/components/ui/toaster";
import { TooltipProvider } from "@/components/ui/tooltip";
import NotFound from "@/pages/not-found";
import Home from "@/pages/Home";
import Search from "@/pages/Search";
import Compare from "@/pages/Compare";
import Calculator from "@/pages/Calculator";
import TechReference from "@/pages/TechReference";
import LubesNThings from "@/pages/LubesNThings";

function Router() {
  return (
    <Switch>
      <Route path="/" component={Home} />
      <Route path="/search" component={Search} />
      <Route path="/compare" component={Compare} />
      <Route path="/calculator" component={Calculator} />
      <Route path="/tech-reference" component={TechReference} />
      <Route path="/lubes-n-things" component={LubesNThings} />
      <Route component={NotFound} />
    </Switch>
  );
}

function App() {
  return (
    <QueryClientProvider client={queryClient}>
      <TooltipProvider>
        <Toaster />
        <Router />
      </TooltipProvider>
    </QueryClientProvider>
  );
}

export default App;
