import { ExternalLink } from "lucide-react";

interface PartsStoreButtonProps {
  partNumber: string;
  store: "Summit" | "JEGS";
}

export function PartsStoreButton({ partNumber, store }: PartsStoreButtonProps) {
  const getStoreUrl = () => {
    const encodedPart = encodeURIComponent(partNumber);
    if (store === "Summit") {
      return `https://www.summitracing.com/search?SortBy=BestKeywordMatch&SortOrder=Ascending&keyword=${encodedPart}`;
    }
    return `https://www.jegs.com/search?q=${encodedPart}`;
  };

  const handleClick = (e: React.MouseEvent) => {
    e.preventDefault();
    e.stopPropagation();
    window.open(getStoreUrl(), "_blank", "noopener,noreferrer");
  };

  const styles = store === "Summit" 
    ? "bg-[#d32f2f] hover:bg-[#b71c1c] text-white" 
    : "bg-[#ffeb3b] hover:bg-[#fdd835] text-black";

  return (
    <button
      onClick={handleClick}
      className={`flex items-center justify-center gap-2 px-3 py-2 rounded-md text-xs font-bold transition-colors ${styles}`}
      data-testid={`button-find-${store.toLowerCase()}-${partNumber}`}
    >
      <ExternalLink className="w-3 h-3" />
      Find on {store}
    </button>
  );
}
