export interface Part {
  id: string;
  partNumber: string;
  stampedCode?: string;
  name: string;
  category: 'Block' | 'Head' | 'Camshaft' | 'Intake' | 'Crankshaft' | 'Injector' | 'Oil Pump' | 'Oil Pan';
  generation: 'Gen 3' | 'Gen 4' | 'Both';
  specs: Record<string, string | number>;
  description: string;
}

export const gmParts: Part[] = [
  // Blocks
  {
    id: 'ls1-block',
    partNumber: '12561168',
    name: 'LS1 Aluminum Block',
    category: 'Block',
    generation: 'Gen 3',
    specs: {
      'Material': 'Aluminum',
      'Bore': '3.898 in',
      'Stroke': '3.622 in',
      'Displacement': '5.7L',
      'Main Caps': '6-bolt powdered metal',
      'Weight': '107 lbs'
    },
    description: 'The original LS1 block introduced in the 1997 Corvette. Features aluminum construction with cast-in iron cylinder liners.'
  },
  {
    id: 'ls6-block',
    partNumber: '12561166',
    name: 'LS6 Aluminum Block',
    category: 'Block',
    generation: 'Gen 3',
    specs: {
      'Material': 'Aluminum',
      'Bore': '3.898 in',
      'Stroke': '3.622 in',
      'Displacement': '5.7L',
      'Main Caps': '6-bolt powdered metal',
      'Notes': 'Improved bay-to-bay breathing windows'
    },
    description: 'Enhanced version of the LS1 block with better crankcase breathing for higher RPM durability.'
  },
  {
    id: 'lq4-block',
    partNumber: '12551364',
    name: 'LQ4 Iron Block',
    category: 'Block',
    generation: 'Gen 3',
    specs: {
      'Material': 'Cast Iron',
      'Bore': '4.000 in',
      'Stroke': '3.622 in',
      'Displacement': '6.0L',
      'Main Caps': 'Iron',
      'Weight': '216 lbs'
    },
    description: 'Rugged iron block 6.0L truck engine foundation. Excellent for boost and heavy-duty applications. Note: The bare block casting (often 12551364 or 12576181) is physically identical to the LQ9/LY6/L96 families.'
  },
  {
    id: 'lq9-block',
    partNumber: '12576181', // Late casting shared with LQ4/LY6/L96 often
    name: 'LQ9 Iron Block',
    category: 'Block',
    generation: 'Gen 3',
    specs: {
      'Material': 'Cast Iron',
      'Bore': '4.000 in',
      'Stroke': '3.622 in',
      'Displacement': '6.0L',
      'Main Caps': 'Iron',
      'Compression': 'Higher than LQ4 (due to pistons)',
      'Note': 'Functionally identical casting to LQ4/LY6'
    },
    description: 'High-output 6.0L found in Escalades/SS trucks. Uses the same 12576181 casting as late LQ4s and Gen 4 LY6/L96 engines. Differences are in pistons and reluctor wheel.'
  },
  {
    id: 'ls3-block',
    partNumber: '12621766',
    name: 'LS3 Aluminum Block',
    category: 'Block',
    generation: 'Gen 4',
    specs: {
      'Material': 'Aluminum',
      'Bore': '4.065 in',
      'Stroke': '3.622 in',
      'Displacement': '6.2L',
      'Main Caps': '6-bolt cross-bolted'
    },
    description: 'The standard for modern performance. Large bore supports high-flow rectangle port heads.'
  },

  // Heads
  {
    id: '241-heads',
    partNumber: '12564241',
    name: 'LS1 "241" Cylinder Heads',
    category: 'Head',
    generation: 'Gen 3',
    specs: {
      'Material': 'Aluminum',
      'Combustion Chamber': '66.67cc',
      'Intake Runner': '200cc',
      'Exhaust Runner': '70cc',
      'Intake Valve': '2.00 in',
      'Exhaust Valve': '1.55 in',
      'Port Shape': 'Cathedral'
    },
    description: 'Standard equipment on later LS1 engines. Good flowing cathedral port design.'
  },
  {
    id: '243-heads',
    partNumber: '12564243',
    name: 'LS6 "243" Cylinder Heads',
    category: 'Head',
    generation: 'Gen 3',
    specs: {
      'Material': 'Aluminum',
      'Combustion Chamber': '64.45cc',
      'Intake Runner': '210cc',
      'Exhaust Runner': '75cc',
      'Intake Valve': '2.00 in (Hollow Stem on Z06)',
      'Exhaust Valve': '1.55 in (Sodium Filled on Z06)',
      'Port Shape': 'Cathedral'
    },
    description: 'The "Holy Grail" of factory cathedral port heads. Excellent flow and compression bump.'
  },
  {
    id: '821-heads',
    partNumber: '12629063',
    name: 'LS3 "821" Cylinder Heads',
    category: 'Head',
    generation: 'Gen 4',
    specs: {
      'Material': 'Aluminum',
      'Combustion Chamber': '68.4cc',
      'Intake Runner': '260cc',
      'Exhaust Runner': '89cc',
      'Intake Valve': '2.165 in',
      'Exhaust Valve': '1.59 in',
      'Port Shape': 'Rectangle'
    },
    description: 'High-flow rectangle port heads found on LS3 engines. Massive airflow potential.'
  },
  {
    id: '317-heads',
    partNumber: '12562317',
    name: 'LQ4 "317" Cylinder Heads',
    category: 'Head',
    generation: 'Gen 3',
    specs: {
      'Material': 'Aluminum',
      'Combustion Chamber': '71.06cc',
      'Intake Runner': '210cc',
      'Exhaust Runner': '75cc',
      'Intake Valve': '2.00 in',
      'Exhaust Valve': '1.55 in',
      'Port Shape': 'Cathedral'
    },
    description: 'Functionally identical ports to the 243 head but with a larger combustion chamber. Popular for boosted applications to lower compression.'
  },

  // Camshafts
  // === GEN 3 CAMSHAFTS ===
  {
    id: 'ls1-cam-early',
    partNumber: '12560965',
    stampedCode: '0965',
    name: 'Early LS1 Camshaft (97-00)',
    category: 'Camshaft',
    generation: 'Gen 3',
    specs: {
      'Duration @ .050': '198/209',
      'Lift': '.500/.500',
      'LSA': '119.5',
      'Type': 'Hydraulic Roller',
      'Valve Springs': 'Stock (Single)'
    },
    description: 'Found in 1997-2000 Corvette LS1s and 1998-2000 F-Body LS1s. Known as the "0965" cam.'
  },
  {
    id: 'ls1-cam-late',
    partNumber: '12561721',
    stampedCode: '1721',
    name: 'Late LS1 / LQ4 / LQ9 Camshaft',
    category: 'Camshaft',
    generation: 'Gen 3',
    specs: {
      'Duration @ .050': '196/207',
      'Lift': '.467/.479',
      'LSA': '116',
      'Type': 'Hydraulic Roller',
      'Valve Springs': 'Stock (Single)'
    },
    description: 'The standard "1721" cam found in 2001-2004 LS1s, and almost all 6.0L LQ4/LQ9 truck engines. Great all-around torque.'
  },
  {
    id: 'truck-cam-small',
    partNumber: '12560967',
    stampedCode: '0967',
    name: '4.8L / 5.3L Truck Camshaft',
    category: 'Camshaft',
    generation: 'Gen 3',
    specs: {
      'Duration @ .050': '191/190',
      'Lift': '.457/.466',
      'LSA': '114',
      'Type': 'Hydraulic Roller',
      'Valve Springs': 'Stock (Single)'
    },
    description: 'The ubiquitous "0967" cam found in millions of 4.8L and 5.3L Gen 3 trucks (Silverado, Tahoe, etc). Designed for low-end torque.'
  },
  {
    id: 'ls6-cam-01',
    partNumber: '12560950',
    stampedCode: '0950',
    name: '2001 LS6 Camshaft',
    category: 'Camshaft',
    generation: 'Gen 3',
    specs: {
      'Duration @ .050': '204/211',
      'Lift': '.525/.525',
      'LSA': '116',
      'Type': 'Hydraulic Roller',
      'Valve Springs': 'Yellow/Blue (GM 12499224)'
    },
    description: 'Found only in the 2001 Z06 Corvette. A good upgrade over the LS1 cam but less aggressive than the 02+ LS6 cam.'
  },
  {
    id: 'ls6-cam-02',
    partNumber: '12565308',
    stampedCode: '5308',
    name: '2002+ LS6 Camshaft',
    category: 'Camshaft',
    generation: 'Gen 3',
    specs: {
      'Duration @ .050': '204/218',
      'Lift': '.551/.547',
      'LSA': '117.5',
      'Type': 'Hydraulic Roller',
      'Valve Springs': 'Yellow/Blue (GM 12499224)'
    },
    description: 'The legendary "5308" Z06 cam. The best factory Gen 3 cam for naturally aspirated power. 3-bolt design.'
  },

  // === GEN 4 CAMSHAFTS ===
  {
    id: 'ls2-cam',
    partNumber: '12574519',
    stampedCode: '4519',
    name: 'LS2 Camshaft',
    category: 'Camshaft',
    generation: 'Gen 4',
    specs: {
      'Duration @ .050': '204/211',
      'Lift': '.525/.525',
      'LSA': '116',
      'Type': 'Hydraulic Roller',
      'Sensor': '1x (early) or 4x (late)',
      'Valve Springs': 'Yellow/Blue (GM 12499224)'
    },
    description: 'Standard in 6.0L LS2 engines (GTO, Corvette, TBSS). Similar specs to the 2001 LS6 cam.'
  },
  {
    id: 'ls3-cam',
    partNumber: '12623063',
    stampedCode: '3063',
    name: 'LS3 Camshaft (Manual)',
    category: 'Camshaft',
    generation: 'Gen 4',
    specs: {
      'Duration @ .050': '204/211',
      'Lift': '.551/.525',
      'LSA': '117',
      'Bolt Pattern': '1-Bolt',
      'Gen 3 Install': 'Not Recommended',
      'Valve Springs': 'Blue (GM 12625033)'
    },
    description: 'Factory 1-bolt cam for the 6.2L LS3 (Manual Trans). Great power but requires Gen 4 timing gear conversion.'
  },
  {
    id: 'ls9-cam',
    partNumber: '12638427',
    stampedCode: '8427',
    name: 'LS9 Camshaft',
    category: 'Camshaft',
    generation: 'Gen 4',
    specs: {
      'Duration @ .050': '211/230',
      'Lift': '.562/.558',
      'LSA': '122.5',
      'Bolt Pattern': '3-Bolt',
      'Gen 3 Install': 'Requires front cover',
      'Valve Springs': 'LS9/LS3 Blue (GM 12625033)'
    },
    description: 'Designed for the supercharged ZR1. 3-bolt design makes it a popular swap for boosted Gen 3/4 engines.'
  },
  {
    id: 'ls7-cam',
    partNumber: '12638426',
    stampedCode: '8426',
    name: 'LS7 Camshaft',
    category: 'Camshaft',
    generation: 'Gen 4',
    specs: {
      'Duration @ .050': '211/230',
      'Lift': '.591/.591',
      'LSA': '120',
      'Ratio': '1.8 Rockers Required',
      'Valve Springs': 'LS7 Springs (GM 12638426)'
    },
    description: 'The massive 7.0L Z06 cam. Requires 1.8 ratio rocker arms to achieve listed lift. Not a direct drop-in for most due to lift/rocker requirements.'
  },
  {
    id: 'lsa-cam',
    partNumber: '12605527',
    stampedCode: '5527',
    name: 'LSA Camshaft',
    category: 'Camshaft',
    generation: 'Gen 4',
    specs: {
      'Duration @ .050': '198/216',
      'Lift': '.480/.480',
      'LSA': '122.5',
      'Bolt Pattern': '1-Bolt',
      'Valve Springs': 'Stock LSA'
    },
    description: 'Found in the supercharged CTS-V and ZL1. Wide LSA for smooth idle and boost, but lower lift than LS9.'
  },
  {
    id: 'ly6-cam',
    partNumber: '12604877',
    stampedCode: '4877',
    name: 'LY6 / L96 VVT Camshaft',
    category: 'Camshaft',
    generation: 'Gen 4',
    specs: {
      'Duration @ .050': '196/201',
      'Lift': '.467/.479',
      'LSA': 'VVT Controlled',
      'Type': 'VVT (Single Bolt)',
      'Valve Springs': 'Stock'
    },
    description: 'Standard Variable Valve Timing (VVT) cam for Gen 4 6.0L truck engines. Requires phaser limiter for cam swaps.'
  },
  {
    id: 'afm-53-cam',
    partNumber: '12625437',
    stampedCode: '5437',
    name: '5.3L AFM Camshaft (LMG/LC9)',
    category: 'Camshaft',
    generation: 'Gen 4',
    specs: {
      'Duration @ .050': '190/191',
      'Lift': '.466/.457',
      'LSA': '114',
      'Type': 'AFM (Single Bolt)',
      'Valve Springs': 'Stock'
    },
    description: 'Standard cam for Active Fuel Management (AFM/DOD) equipped 5.3L engines. Not performance oriented.'
  },
  {
    id: 'l99-cam',
    partNumber: '12625436',
    stampedCode: '5436',
    name: 'L99 Camshaft (Auto LS3)',
    category: 'Camshaft',
    generation: 'Gen 4',
    specs: {
      'Duration @ .050': '195/201',
      'Lift': '.500/.492',
      'LSA': '115',
      'Type': 'AFM + VVT',
      'Valve Springs': 'Stock'
    },
    description: 'Found in Automatic Gen 5 Camaros (L99). Features both AFM and VVT. Significantly less aggressive than the manual LS3 cam.'
  },

  // Intakes
  {
    id: 'ls1-intake',
    partNumber: '12561182',
    name: 'LS1 Intake Manifold',
    category: 'Intake',
    generation: 'Gen 3',
    specs: {
      'Material': 'Composite',
      'Design': 'Equal Length Runner',
      'Throttle Body': '3-bolt',
      'Port Shape': 'Cathedral'
    },
    description: 'Original equipment intake. Decent flow but often upgraded to LS6.'
  },
  {
    id: 'ls6-intake',
    partNumber: '12561184',
    name: 'LS6 Intake Manifold',
    category: 'Intake',
    generation: 'Gen 3',
    specs: {
      'Material': 'Composite',
      'Design': 'Equal Length Runner',
      'Throttle Body': '3-bolt',
      'Port Shape': 'Cathedral',
      'Plenum Volume': 'Larger than LS1'
    },
    description: 'The gold standard for factory cathedral port intakes. Significant gains over LS1 intake.'
  },
  {
    id: 'ls3-intake',
    partNumber: '12602477',
    name: 'LS3 Intake Manifold',
    category: 'Intake',
    generation: 'Gen 4',
    specs: {
      'Material': 'Composite',
      'Design': 'Equal Length Runner',
      'Throttle Body': '4-bolt (90mm)',
      'Port Shape': 'Rectangle'
    },
    description: 'High-flowing factory intake for rectangle port heads. Supports over 500hp stock.'
  },

  // === GEN 4 TRUCK ENGINES & COMPONENTS ===

  // Blocks
  {
    id: 'ly6-block',
    partNumber: '12576181', // Shared casting with L96
    name: 'LY6 Iron Block',
    category: 'Block',
    generation: 'Gen 4',
    specs: {
      'Material': 'Cast Iron',
      'Bore': '4.000 in',
      'Stroke': '3.622 in',
      'Displacement': '6.0L',
      'Main Caps': 'Iron',
      'Weight': '216 lbs'
    },
    description: 'Gen 4 iron block 6.0L. Replaced the LQ4. Functionally identical casting to the LQ9/L96 (12576181). Differences are internal (VVT/Pistons).'
  },
  {
    id: 'l96-block',
    partNumber: '12576181', // Updated correct casting
    name: 'L96 Iron Block',
    category: 'Block',
    generation: 'Gen 4',
    specs: {
      'Material': 'Cast Iron',
      'Bore': '4.000 in',
      'Stroke': '3.622 in',
      'Displacement': '6.0L',
      'Main Caps': 'Iron',
      'Flex Fuel': 'Capable'
    },
    description: 'Updated version of the LY6. Uses the same 12576181 casting found in late LQ4s, LQ9s, and LY6s. Robust iron foundation.'
  },
  {
    id: 'l92-block',
    partNumber: '12584724',
    name: 'L92 Aluminum Block',
    category: 'Block',
    generation: 'Gen 4',
    specs: {
      'Material': 'Aluminum',
      'Bore': '4.065 in',
      'Stroke': '3.622 in',
      'Displacement': '6.2L',
      'VVT': 'Yes',
      'AFM': 'No (on early models)'
    },
    description: 'All-aluminum 6.2L truck engine. The precursor to the LS3, found in Denali and Escalade models.'
  },

  // Gen 5 Ecotec3 / Gen 4 Late Transition (User asked for "Eco tech engines from half ton")
  // Note: Ecotec3 is technically Gen 5 LT architecture, but often grouped in "modern truck engines".
  // Assuming user means Gen 4 AFM/VVT 5.3s (LC9, LH6, LMG, LY5) often found in half-tons before 2014, 
  // or the L83/L86 Gen 5. 
  // Given "Gen 3 and Gen 4" scope in prompt 1, I will focus on Gen 4 5.3L variants which are very common.

  {
    id: 'lmg-block',
    partNumber: '12569513', // Casting generic
    name: 'LMG Iron Block 5.3L',
    category: 'Block',
    generation: 'Gen 4',
    specs: {
      'Material': 'Cast Iron',
      'Bore': '3.780 in',
      'Stroke': '3.622 in',
      'Displacement': '5.3L',
      'AFM': 'Yes',
      'VVT': 'Yes (2010+)'
    },
    description: 'The workhorse iron block Gen 4 5.3L found in countless Silverados and Sierras. Flex-fuel capable.'
  },
  {
    id: 'lc9-block',
    partNumber: '12569513', // Casting generic
    name: 'LC9 Aluminum Block 5.3L',
    category: 'Block',
    generation: 'Gen 4',
    specs: {
      'Material': 'Aluminum',
      'Bore': '3.780 in',
      'Stroke': '3.622 in',
      'Displacement': '5.3L',
      'AFM': 'Yes',
      'VVT': 'Yes (2010+)',
      'Weight': '100 lbs lighter than Iron'
    },
    description: 'Aluminum version of the Gen 4 5.3L. Found in 4WD Suburban/Yukon and some trucks.'
  },
  {
    id: 'lh6-block',
    partNumber: '12569513',
    name: 'LH6 Aluminum Block 5.3L',
    category: 'Block',
    generation: 'Gen 4',
    specs: {
      'Material': 'Aluminum',
      'Bore': '3.780 in',
      'Stroke': '3.622 in',
      'Displacement': '5.3L',
      'AFM': 'Yes',
      'VVT': 'No (early), Yes (late)'
    },
    description: 'Early Gen 4 aluminum 5.3L. Replaced the Gen 3 LM4. Known for AFM lifter issues in early years.'
  },

  // Heads for Trucks
  {
    id: '823-heads',
    partNumber: '12629063', // Similar casting to 821
    name: 'L92/LY6 "823" Cylinder Heads',
    category: 'Head',
    generation: 'Gen 4',
    specs: {
      'Material': 'Aluminum',
      'Combustion Chamber': '68-70cc',
      'Intake Runner': '260cc',
      'Exhaust Runner': '89cc',
      'Intake Valve': '2.165 in (Heavy)',
      'Exhaust Valve': '1.59 in',
      'Port Shape': 'Rectangle'
    },
    description: 'Rectangle port heads found on 6.0L/6.2L trucks (LY6, L92, L96). Almost identical to LS3 heads but with heavier valves.'
  },
  {
    id: '799-heads',
    partNumber: '12610046',
    name: 'Gen 4 "799" Cylinder Heads',
    category: 'Head',
    generation: 'Gen 4',
    specs: {
      'Material': 'Aluminum',
      'Combustion Chamber': '64cc',
      'Intake Runner': '210cc',
      'Exhaust Runner': '75cc',
      'Intake Valve': '2.00 in',
      'Exhaust Valve': '1.55 in',
      'Port Shape': 'Cathedral'
    },
    description: 'Found on many Gen 4 5.3L engines (LC9, LMG). Cast with the same tooling as the legendary 243 LS6 heads.'
  },
  {
    id: '243-truck-heads',
    partNumber: '12564243',
    name: 'Gen 4 "243" Truck Heads',
    category: 'Head',
    generation: 'Gen 4',
    specs: {
      'Material': 'Aluminum',
      'Combustion Chamber': '64cc',
      'Intake Runner': '210cc',
      'Exhaust Runner': '75cc',
      'Intake Valve': '2.00 in',
      'Exhaust Valve': '1.55 in',
      'Port Shape': 'Cathedral'
    },
    description: 'Identical to LS6 heads but found on 4.8L/5.3L Gen 4 trucks. Does not have lightweight valves like the Z06 version.'
  },

  // Intakes for Trucks
  {
    id: 'tbss-intake',
    partNumber: '12580420',
    name: 'TBSS / Gen 4 Truck Intake',
    category: 'Intake',
    generation: 'Gen 3',
    specs: {
      'Material': 'Composite',
      'Design': 'Long Runner',
      'Throttle Body': '4-bolt (87mm)',
      'Port Shape': 'Cathedral',
      'Flow': 'Outflows LS6 intake'
    },
    description: 'The best factory cathedral port intake. Found on Trailblazer SS and Gen 4 trucks (NBSS style).'
  },
  {
    id: 'l92-intake',
    partNumber: '12580678',
    name: 'L92/LY6 Truck Intake',
    category: 'Intake',
    generation: 'Gen 4',
    specs: {
      'Material': 'Composite',
      'Design': 'Long Runner',
      'Throttle Body': '4-bolt (87mm)',
      'Port Shape': 'Rectangle'
    },
    description: 'Rectangle port truck intake. Excellent torque production but tall profile makes hood clearance difficult in cars.'
  },

  // === FUEL INJECTORS ===
  {
    id: 'ls1-injector-97-98',
    partNumber: '12554271',
    name: 'LS1 Injector 97-98 (28lb)',
    category: 'Injector',
    generation: 'Gen 3',
    specs: {
      'Flow Rate': '~28 lb/hr @ 58psi',
      'Connector': 'EV1 (Jetronic)',
      'Length': 'Standard (Tall)',
      'Impedance': 'High'
    },
    description: 'Rare perimeter-bolt valve cover engines (1997-1998 LS1).'
  },
  {
    id: 'ls1-injector-99-00',
    partNumber: '12555894',
    name: 'LS1 Injector 99-00 (26lb)',
    category: 'Injector',
    generation: 'Gen 3',
    specs: {
      'Flow Rate': '~26 lb/hr @ 58psi',
      'Connector': 'EV1 (Jetronic)',
      'Length': 'Standard (Tall)',
      'Impedance': 'High'
    },
    description: 'Standard LS1 injector found on 1999-2000 models.'
  },
  {
    id: 'ls1-ls6-injector-01-04',
    partNumber: '12561462',
    name: 'LS1 / LS6 Injector 01-04 (29-30lb)',
    category: 'Injector',
    generation: 'Gen 3',
    specs: {
      'Flow Rate': '~29-30 lb/hr @ 58psi',
      'Connector': 'EV1 (Jetronic)',
      'Length': 'Standard (Tall)',
      'Impedance': 'High'
    },
    description: 'Found on Z06 and late-model C5 Corvettes (2001-2004). Excellent factory upgrade for earlier LS1s.'
  },
  {
    id: 'truck-injector-early-small',
    partNumber: '17113698',
    name: 'Early Truck Injector (22lb)',
    category: 'Injector',
    generation: 'Gen 3',
    specs: {
      'Flow Rate': '~22 lb/hr @ 58psi',
      'Connector': 'Multec 2',
      'Length': 'Truck (Short)',
      'Impedance': 'High'
    },
    description: 'Found on very early 1999-2000 trucks. Avoid these; they are small.'
  },
  {
    id: 'truck-injector-std',
    partNumber: '25317628',
    name: 'Truck Injector 4.8/5.3/6.0 (25lb)',
    category: 'Injector',
    generation: 'Gen 3',
    specs: {
      'Flow Rate': '~25 lb/hr @ 58psi',
      'Connector': 'Multec 2',
      'Length': 'Truck (Short)',
      'Impedance': 'High'
    },
    description: 'The standard "Junkyard" injector found on millions of trucks (LM7, LQ4).'
  },
  {
    id: 'l59-flex-injector',
    partNumber: '12580426',
    name: 'L59 Flex Fuel Injector (36lb)',
    category: 'Injector',
    generation: 'Gen 3',
    specs: {
      'Flow Rate': '~33-36 lb/hr @ 58psi',
      'Connector': 'EV6 (USCAR)',
      'Length': 'Truck (Short)',
      'Flex Fuel': 'Yes',
      'Warning': 'Gen 3 engine with Gen 4 connector'
    },
    description: 'Found on L59 Flex Fuel Gen 3 engines. Warning: This is a Gen 3 engine that uses the "Gen 4 Style" EV6 connector.'
  },
  {
    id: 'ls2-injector',
    partNumber: '12569113',
    name: 'LS2 Injector (34lb)',
    category: 'Injector',
    generation: 'Gen 4',
    specs: {
      'Flow Rate': '~34 lb/hr @ 58psi',
      'Connector': 'EV6 (USCAR)',
      'Length': 'LS2 (Medium)',
      'Impedance': 'High'
    },
    description: 'Good mild upgrade for Gen 3 engines (requires adapter). Standard on LS2 engines (GTO/Vette/TBSS).'
  },
  {
    id: 'truck-gen4-gas-injector',
    partNumber: '12580681',
    name: 'Gen 4 Truck Injector (Gas) (30lb)',
    category: 'Injector',
    generation: 'Gen 4',
    specs: {
      'Flow Rate': '~30 lb/hr @ 58psi',
      'Connector': 'EV6 (USCAR)',
      'Length': 'Truck (Short)',
      'Fuel': 'Gasoline'
    },
    description: 'Standard injector for LY6, LH6, LMG (Gasoline models).'
  },
  {
    id: 'truck-flex-injector',
    partNumber: '12594512',
    name: 'Gen 4 Truck Flex Injector (36lb)',
    category: 'Injector',
    generation: 'Gen 4',
    specs: {
      'Flow Rate': '36 lb/hr @ 58psi',
      'Connector': 'EV6 (USCAR)',
      'Length': 'Truck (Short)',
      'Flex Fuel': 'Yes'
    },
    description: 'Common upgrade found on Gen 4 Flex Fuel 5.3L engines (LMG/LC9). Good budget upgrade for 5.3L builds.'
  },
  {
    id: 'ls3-injector',
    partNumber: '12576341',
    name: 'LS3 / LS7 / L76 / L99 Injector (42lb)',
    category: 'Injector',
    generation: 'Gen 4',
    specs: {
      'Flow Rate': '~42 lb/hr @ 58psi',
      'Connector': 'EV6 (USCAR)',
      'Length': 'LS3 (Shortest)',
      'Application': 'LS3, LS7, L76, L99'
    },
    description: 'Short Body. The standard "Square Port" engine injector. Found in C6 Corvette and Gen 5 Camaro SS (Manual & Auto).'
  },
  {
    id: 'l96-injector',
    partNumber: '12613412',
    name: 'L96 Flex Fuel Injector (50lb)',
    category: 'Injector',
    generation: 'Gen 4',
    specs: {
      'Flow Rate': '~50 lb/hr @ 58psi',
      'Connector': 'EV6 (USCAR)',
      'Length': 'Truck (Short)',
      'Flex Fuel': 'Yes'
    },
    description: 'Top Pick. High flow factory injector found in 2010+ 2500HD trucks (L96).'
  },
  {
    id: 'l9h-injector',
    partNumber: '12609749',
    name: 'L94 / L9H Flex Injector (54lb)',
    category: 'Injector',
    generation: 'Gen 4',
    specs: {
      'Flow Rate': '~54 lb/hr @ 58psi',
      'Connector': 'EV6 (USCAR)',
      'Length': 'Truck (Short)',
      'Flex Fuel': 'Yes'
    },
    description: 'Massive flow. Found in 6.2L Flex Fuel Escalades/Denalis (L94/L9H).'
  },
  {
    id: 'lsa-injector',
    partNumber: '12598646',
    name: 'LSA / LS9 Injector (56lb)',
    category: 'Injector',
    generation: 'Gen 4',
    specs: {
      'Flow Rate': '~56 lb/hr @ 58psi',
      'Connector': 'EV6 (USCAR)',
      'Length': 'LS3 (Shortest)',
      'Application': 'LSA / LS9'
    },
    description: 'The factory supercharged injector. Often called the "LSA 52lb" injector. Found in CTS-V, ZL1, and ZR1.'
  },



  // === OIL PUMPS ===
  {
    id: 'ls-pump-std',
    partNumber: '12586665',
    name: 'Standard Volume Oil Pump (Gen 3)',
    category: 'Oil Pump',
    generation: 'Gen 3',
    specs: {
      'Flow Rate': '~6.8 GPM',
      'Melling': 'M295',
      'Application': 'LS1, LS6, LQ4, LQ9, LS2'
    },
    description: 'Base pump for almost all Gen 3 engines and Gen 4 engines without AFM/VVT. Do NOT use on engines with active AFM/DOD.'
  },
  {
    id: 'ls-pump-hv',
    partNumber: '12612289',
    name: 'High Volume Oil Pump (Gen 4)',
    category: 'Oil Pump',
    generation: 'Gen 4',
    specs: {
      'Flow Rate': '~8.8 - 9.5 GPM',
      'Melling': 'M365',
      'Volume': '+30% over Standard',
      'Application': 'L99, L92, L94, LSA, AFM/VVT Engines'
    },
    description: 'Required for Gen 4 engines with complex valvetrains (AFM/VVT). Can be used on standard engines for extra insurance.'
  },

  // === OIL PANS ===
  {
    id: 'fbody-oil-pan',
    partNumber: '12628771',
    name: 'F-Body Oil Pan (98-02 Camaro/Firebird)',
    category: 'Oil Pan',
    generation: 'Gen 3',
    specs: {
      'Sump Location': 'Rear (Stepped)',
      'Capacity': '5.5 qt',
      'Engine': 'LS1',
      'Replaces': '12558899'
    },
    description: 'The "Gold Standard" for muscle car swaps. Shallow front section makes it ideal for clearing crossmembers in 60s/70s GM muscle cars (Camaros, Chevelles, Novas).'
  },
  {
    id: 'h3-muscle-oil-pan',
    partNumber: '12624621',
    name: 'Hummer H3 / Muscle Car Oil Pan',
    category: 'Oil Pan',
    generation: 'Gen 4',
    specs: {
      'Sump Location': 'Rear',
      'Capacity': '5.5 qt',
      'Engine': 'LH8 (5.3L)',
      'Replaces': '12614821'
    },
    description: 'Often marketed as the "Muscle Car Oil Pan Kit" by GM Performance. Clears many crossmembers but sump is very deep - can hang below frame rails on lowered cars.'
  },
  {
    id: 'ctsv-oil-pan',
    partNumber: '12631828',
    name: 'CTS-V Oil Pan',
    category: 'Oil Pan',
    generation: 'Gen 4',
    specs: {
      'Sump Location': 'Rear',
      'Capacity': '6.0 qt',
      'Engine': 'LS6, LS2, LSA',
      'Replaces': '12605814, 12628451'
    },
    description: 'Popular alternative when F-Body pan is unavailable. Shorter than truck pans but hangs slightly lower than F-body pan.'
  },
  {
    id: 'truck-oil-pan',
    partNumber: '12640746',
    name: 'Truck / SUV Oil Pan',
    category: 'Oil Pan',
    generation: 'Both',
    specs: {
      'Sump Location': 'Rear (Deep)',
      'Capacity': '6.0 qt',
      'Engine': 'Vortec 4800, 5300, 6000, 6200',
      'Replaces': '12628772, 12579273'
    },
    description: 'The most common pan found in junkyards. Very deep sump for high-angle truck use. Almost never fits into car chassis without cutting or dragging.'
  },
  {
    id: 'gto-front-sump-pan',
    partNumber: '12599397',
    name: 'GTO / Holden Front Sump Oil Pan',
    category: 'Oil Pan',
    generation: 'Gen 4',
    specs: {
      'Sump Location': 'Front',
      'Capacity': '6.0 qt',
      'Engine': 'LS1, LS2',
      'Early PN': '12581209'
    },
    description: 'Unique front sump design. Essential for swaps into chassis requiring front sump (Nissan S-chassis, early Ford Mustangs, BMW E30s).'
  },
  {
    id: 'c6-corvette-oil-pan',
    partNumber: '12624617',
    name: 'C6 Corvette Oil Pan',
    category: 'Oil Pan',
    generation: 'Gen 4',
    specs: {
      'Sump Location': 'Rear (Batwing)',
      'Capacity': '5.5 qt',
      'Engine': 'LS2, LS3',
      'Design': 'Internal Baffling'
    },
    description: 'Gullwing/Batwing style with internal baffling. Good for cornering but the "wings" can interfere with headers or frame rails in tight swap chassis.'
  },
  {
    id: 'c5-corvette-oil-pan',
    partNumber: '12561828',
    name: 'C5 Corvette Batwing Oil Pan',
    category: 'Oil Pan',
    generation: 'Gen 3',
    specs: {
      'Sump Location': 'Rear (Extreme Gullwing)',
      'Capacity': '5.5 qt',
      'Engine': 'LS1, LS6',
      'Years': '1997-2004'
    },
    description: 'The famous two-piece looking pan designed for high-G cornering. Massive side "wings" make it difficult to fit in anything other than a Corvette or wide-rail chassis.'
  },
  {
    id: 'gen5-camaro-oil-pan',
    partNumber: '12640748',
    name: 'Gen 5 Camaro / G8 / SS Oil Pan',
    category: 'Oil Pan',
    generation: 'Gen 4',
    specs: {
      'Sump Location': 'Rear',
      'Capacity': '8.0 qt',
      'Engine': 'LS3, L99',
      'Replaces': '12624619'
    },
    description: 'Found on 2010-2015 Camaro SS and Pontiac G8/Chevy SS sedans. Very large oil capacity but deep front section can interfere with steering linkage on older cars.'
  },
  {
    id: 'ls7-dry-sump-pan',
    partNumber: '12627845',
    name: 'LS7 Dry Sump Pan',
    category: 'Oil Pan',
    generation: 'Gen 4',
    specs: {
      'Sump Location': 'Dry Sump',
      'Capacity': 'External Tank',
      'Engine': 'LS7',
      'Note': 'Part of semi-dry sump system'
    },
    description: 'Part of the LS7 semi-dry sump system. Requires external oil tank and lines. Crank snout is longer to drive the larger oil pump.'
  },
  {
    id: 'ls9-dry-sump-pan',
    partNumber: '12627846',
    name: 'LS9 Dry Sump Pan',
    category: 'Oil Pan',
    generation: 'Gen 4',
    specs: {
      'Sump Location': 'Dry Sump',
      'Capacity': 'External Tank',
      'Engine': 'LS9',
      'Note': 'Part of semi-dry sump system'
    },
    description: 'Part of the supercharged LS9 semi-dry sump system. Requires external oil tank, lines, and extended crank snout.'
  }
];
