import { Layout } from "@/components/Layout";
import { Card, CardContent } from "@/components/ui/card";
import { Calculator as CalcIcon } from "lucide-react";

export default function Calculator() {
  return (
    <Layout>
      <div className="max-w-4xl mx-auto space-y-12">
        <div className="text-center space-y-4 border-b-2 border-primary/20 pb-8">
          <h1 className="text-4xl md:text-5xl font-serif font-bold text-foreground">
            HP Calculator
          </h1>
          <p className="text-xl text-muted-foreground font-medium max-w-2xl mx-auto">
            Estimate potential output based on factory component combinations.
          </p>
        </div>

        <Card className="border-2 border-dashed border-border/50 bg-muted/10">
          <CardContent className="pt-6 text-center py-16">
            <div className="flex justify-center mb-6">
              <CalcIcon className="w-24 h-24 opacity-30" />
            </div>
            <h3 className="font-bold text-2xl text-muted-foreground mb-3">Coming Soon</h3>
            <p className="text-muted-foreground max-w-md mx-auto">
              The theoretical horsepower calculator is currently under development. Check back soon!
            </p>
          </CardContent>
        </Card>
      </div>
    </Layout>
  );
}
