import { Layout } from "@/components/Layout";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { AlertTriangle, CheckCircle, XCircle } from "lucide-react";
import { PartsStoreButton } from "@/components/PartsStoreButton";

export default function LubesNThings() {
  return (
    <Layout>
      <div className="max-w-4xl mx-auto space-y-12">
        <div className="text-center space-y-4 border-b-2 border-primary/20 pb-8">
          <h1 className="text-4xl md:text-5xl font-serif font-bold text-foreground">
            Lubes n Things
          </h1>
          <p className="text-xl text-muted-foreground font-medium max-w-2xl mx-auto">
            Factory GM recommended oils, gaskets, and sealants for LS engines.
          </p>
        </div>

        {/* Article Section */}
        <section className="space-y-4">
          <Card className="border-2 border-primary/20 bg-card">
            <CardContent className="pt-6 space-y-4">
              <h3 className="text-xl font-serif font-bold">Don't Let the "Boring Stuff" Kill Your Build</h3>
              <p className="text-muted-foreground leading-relaxed">
                It's not the cam you choose or the heads you bolt on that determines if your engine survives—it's the fluids and seals holding it all together. The LS platform is incredible, but it requires specific chemistry to seal right.
              </p>
              <p className="text-muted-foreground leading-relaxed">
                GM engineers spent thousands of hours testing these consumables so you don't have to guess. If you want your swap to leak-free and reliable, trust the factory specs. I've compiled the specific GM-recommended list below to save you the headache.
              </p>
              <p className="text-sm text-muted-foreground/80 italic border-t border-border/50 pt-4 mt-4">
                <strong>Transparency:</strong> I've included affiliate links for these items. If you buy through them, I make a small percentage that goes directly back into improving this app. Thanks for the support!
              </p>
            </CardContent>
          </Card>
        </section>

        {/* Gasket Re-usability Article */}
        <section className="space-y-4">
          <Card className="border-2 border-primary/20 bg-card">
            <CardContent className="pt-6 space-y-4">
              <h3 className="text-xl font-serif font-bold">Cover Gasket Re-Usability</h3>
              <p className="text-muted-foreground leading-relaxed">
                GM intended for many LS platform gaskets to be re-usable. The timing chain cover, oil pan, valve covers, and transmission pan gaskets were all designed with multiple uses in mind.
              </p>
              <p className="text-muted-foreground leading-relaxed">
                Always inspect the gaskets visually before re-installing, but if they seem fine, 9 times out of 10 the factory gasket is re-usable—and a better option than cheap aftermarket gaskets.
              </p>
            </CardContent>
          </Card>
        </section>

        {/* Sealant Advisory Article */}
        <section className="space-y-4">
          <Card className="border-2 border-primary/20 bg-card">
            <CardContent className="pt-6 space-y-4">
              <h3 className="text-xl font-serif font-bold">Sealant Advisory</h3>
              <p className="text-muted-foreground leading-relaxed">
                As stated, most LS gaskets are designed to be used dry. But in my experience, there is nothing at all wrong with adding a little <strong>BLACK RTV</strong> to hold your valve covers or oil pan gasket in place, or using a thin layer of <strong>BLUE RTV</strong> to hold water pump gaskets in place as you install the pump.
              </p>
              <div className="flex items-start gap-3 p-3 rounded-md bg-red-500/10 border border-red-500/30">
                <XCircle className="w-5 h-5 text-red-500 mt-0.5 shrink-0" />
                <div className="space-y-2">
                  <p className="font-bold text-red-700 dark:text-red-400">DO NOT:</p>
                  <ul className="text-sm text-muted-foreground space-y-1">
                    <li>• Use sealant on <strong>intake manifold gaskets</strong></li>
                    <li>• Take your uncle's advice on using <strong>RED RTV</strong> as a substitute for exhaust manifold gaskets</li>
                  </ul>
                </div>
              </div>
            </CardContent>
          </Card>
        </section>

        {/* Engine Oil Section */}
        <section className="space-y-6">
          <div className="flex items-center gap-2 mb-4">
            <div className="w-8 h-8 bg-primary text-primary-foreground flex items-center justify-center rounded-sm font-bold font-serif">1</div>
            <h2 className="text-2xl font-serif font-bold">Engine Oil</h2>
          </div>

          <Card className="border-2 border-primary/20">
            <CardHeader className="bg-muted/30">
              <CardTitle className="text-lg">GM Dexos1 Gen 3 Synthetic Oil</CardTitle>
            </CardHeader>
            <CardContent className="pt-6 space-y-4">
              <p className="text-muted-foreground">
                GM's current standard for <strong>all LS engines</strong> is <strong>dexos1 Gen 3 synthetic oil</strong>. This is the factory-recommended specification for optimal protection and performance.
              </p>
            </CardContent>
          </Card>

          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <Card className="border border-border/60">
              <CardHeader className="pb-2">
                <CardTitle className="text-base flex items-center gap-2">
                  <span className="bg-blue-500 text-white text-xs px-2 py-0.5 rounded">Gen 3</span>
                  Oil Filter
                </CardTitle>
              </CardHeader>
              <CardContent className="space-y-3">
                <p className="font-bold text-lg">ACDelco PF46E</p>
                <p className="text-sm text-muted-foreground">1997–2006 LS Engines</p>
                <p className="text-sm text-muted-foreground">Standard threads: <strong>13/16"</strong></p>
                <div className="flex gap-2 mt-2">
                  <PartsStoreButton partNumber="PF46E" store="Summit" />
                </div>
              </CardContent>
            </Card>

            <Card className="border border-border/60">
              <CardHeader className="pb-2">
                <CardTitle className="text-base flex items-center gap-2">
                  <span className="bg-green-600 text-white text-xs px-2 py-0.5 rounded">Gen 4</span>
                  Oil Filter
                </CardTitle>
              </CardHeader>
              <CardContent className="space-y-3">
                <p className="font-bold text-lg">ACDelco PF48E</p>
                <p className="text-sm text-muted-foreground">2007–2014 LS Engines</p>
                <p className="text-sm text-muted-foreground">Metric threads: <strong>M22x1.5</strong></p>
                <div className="flex gap-2 mt-2">
                  <PartsStoreButton partNumber="PF48E" store="Summit" />
                </div>
              </CardContent>
            </Card>
          </div>
        </section>

        {/* Head Gaskets Section */}
        <section className="space-y-6">
          <div className="flex items-center gap-2 mb-4">
            <div className="w-8 h-8 bg-primary text-primary-foreground flex items-center justify-center rounded-sm font-bold font-serif">2</div>
            <h2 className="text-2xl font-serif font-bold">Head Gaskets</h2>
          </div>

          <Card className="border-2 border-primary/20 bg-muted/10">
            <CardHeader className="bg-muted/30">
              <CardTitle className="text-lg">Factory Gaskets Are Superior</CardTitle>
            </CardHeader>
            <CardContent className="pt-6">
              <p className="text-muted-foreground">
                For head gaskets and exhaust gaskets, the <strong>"Factory" parts are actually superior</strong> to most aftermarket paper gaskets. Don't cheap out here.
              </p>
            </CardContent>
          </Card>

          <Card className="border-2 border-amber-500/50 bg-amber-500/5">
            <CardHeader className="pb-2">
              <CardTitle className="text-lg flex items-center gap-2">
                <span className="text-amber-500">★</span>
                GM LS9 Head Gasket — "The Holy Grail"
              </CardTitle>
            </CardHeader>
            <CardContent className="space-y-4 pt-4">
              <div className="grid grid-cols-2 gap-4 text-sm">
                <div>
                  <p className="text-muted-foreground">Part Number</p>
                  <p className="font-bold font-mono text-lg">#12622033</p>
                </div>
                <div>
                  <p className="text-muted-foreground">Type</p>
                  <p className="font-bold">7-Layer MLS (Multi-Layer Steel)</p>
                </div>
              </div>
              <p className="text-muted-foreground">
                Designed for the <strong>supercharged ZR1 Corvette</strong>. This gasket withstands significantly more boost and cylinder pressure than standard gaskets. The go-to choice for 6.0L and 6.2L performance builds.
              </p>

              <div className="flex items-start gap-3 p-3 rounded-md bg-green-500/10 border border-green-500/30">
                <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 shrink-0" />
                <div>
                  <p className="font-bold text-green-700 dark:text-green-400">Use On:</p>
                  <p className="text-sm text-muted-foreground">4.000" bore blocks or larger — LS2, LS3, LY6, LSA</p>
                </div>
              </div>

              <div className="flex items-start gap-3 p-3 rounded-md bg-red-500/10 border border-red-500/30">
                <XCircle className="w-5 h-5 text-red-500 mt-0.5 shrink-0" />
                <div>
                  <p className="font-bold text-red-700 dark:text-red-400">Do NOT Use On:</p>
                  <p className="text-sm text-muted-foreground">4.8L or 5.3L engines (smaller bore)</p>
                </div>
              </div>
              <div className="flex gap-2 mt-2">
                <PartsStoreButton partNumber="12622033" store="Summit" />
              </div>
            </CardContent>
          </Card>
        </section>

        {/* Exhaust Manifold Gaskets Section */}
        <section className="space-y-6">
          <div className="flex items-center gap-2 mb-4">
            <div className="w-8 h-8 bg-primary text-primary-foreground flex items-center justify-center rounded-sm font-bold font-serif">3</div>
            <h2 className="text-2xl font-serif font-bold">Exhaust Manifold Gaskets</h2>
          </div>

          <Card className="border-2 border-primary/20">
            <CardHeader className="pb-2">
              <CardTitle className="text-lg">GM Factory MLS Gasket</CardTitle>
            </CardHeader>
            <CardContent className="space-y-4 pt-4">
              <div>
                <p className="text-muted-foreground text-sm">Part Number</p>
                <p className="font-bold font-mono text-lg">#12617944</p>
              </div>
              <p className="text-muted-foreground">
                These are <strong>metal multi-layer gaskets</strong> that are <strong>reusable</strong> and almost never blow out. The factory solution is the best solution.
              </p>

              <div className="flex items-start gap-3 p-3 rounded-md bg-red-500/10 border border-red-500/30">
                <XCircle className="w-5 h-5 text-red-500 mt-0.5 shrink-0" />
                <div>
                  <p className="font-bold text-red-700 dark:text-red-400">Avoid:</p>
                  <p className="text-sm text-muted-foreground">Paper aftermarket header gaskets — they <strong>will</strong> leak eventually.</p>
                </div>
              </div>
              <div className="flex gap-2 mt-2">
                <PartsStoreButton partNumber="12617944" store="Summit" />
              </div>
            </CardContent>
          </Card>
        </section>

        {/* Sealants Section */}
        <section className="space-y-6">
          <div className="flex items-center gap-2 mb-4">
            <div className="w-8 h-8 bg-primary text-primary-foreground flex items-center justify-center rounded-sm font-bold font-serif">4</div>
            <h2 className="text-2xl font-serif font-bold">Sealants</h2>
          </div>

          <Card className="border-2 border-primary/20 bg-muted/10">
            <CardContent className="pt-6">
              <p className="text-muted-foreground">
                LS engines are designed to be assembled <strong>mostly dry</strong>. However, you need a specific RTV for the <strong>"Four Corners"</strong> — where the oil pan meets the front/rear covers.
              </p>
            </CardContent>
          </Card>

          <Card className="border-2 border-primary/20">
            <CardHeader className="pb-2">
              <CardTitle className="text-lg">Permatex Ultra Grey (Rigid High-Torque)</CardTitle>
            </CardHeader>
            <CardContent className="space-y-4 pt-4">
              <p className="text-muted-foreground">
                The recommended sealant for LS engine assembly.
              </p>

              <div className="flex items-start gap-3 p-3 rounded-md bg-green-500/10 border border-green-500/30">
                <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 shrink-0" />
                <div>
                  <p className="font-bold text-green-700 dark:text-green-400">Where to Use:</p>
                  <p className="text-sm text-muted-foreground">Apply a small dab only at the corners where the oil pan gasket intersects with the crankshaft covers (front timing cover and rear main seal housing).</p>
                </div>
              </div>

              <div className="flex items-start gap-3 p-3 rounded-md bg-red-500/10 border border-red-500/30">
                <XCircle className="w-5 h-5 text-red-500 mt-0.5 shrink-0" />
                <div>
                  <p className="font-bold text-red-700 dark:text-red-400">Do NOT Use:</p>
                  <p className="text-sm text-muted-foreground">Standard "Blue" or "Black" silicone — they are not rigid enough for the aluminum structural pan design.</p>
                </div>
              </div>
              <div className="flex gap-2 mt-2">
                <PartsStoreButton partNumber="Permatex Ultra Grey" store="Summit" />
              </div>
            </CardContent>
          </Card>
        </section>

        {/* Fel-Pro Gaskets Section */}
        <section className="space-y-6">
          <div className="flex items-center gap-2 mb-4">
            <div className="w-8 h-8 bg-primary text-primary-foreground flex items-center justify-center rounded-sm font-bold font-serif">5</div>
            <h2 className="text-2xl font-serif font-bold">Fel-Pro Gasket Recommendations</h2>
          </div>

          {/* Oil Pan Gasket */}
          <Card className="border-2 border-primary/20">
            <CardHeader className="pb-2 bg-muted/30">
              <CardTitle className="text-lg">1. Oil Pan Gasket</CardTitle>
            </CardHeader>
            <CardContent className="space-y-4 pt-4">
              <p className="text-muted-foreground">
                The Fel-Pro <strong>"PermaDryPlus"</strong> gasket is widely considered superior to the factory gasket because it is a rigid carrier with a molded silicone edge, often blue in color. It is reusable and extremely durable.
              </p>
              <div className="grid grid-cols-2 gap-4 text-sm">
                <div>
                  <p className="text-muted-foreground">Part Number</p>
                  <p className="font-bold font-mono text-lg">Fel-Pro OS 30693 R</p>
                </div>
                <div>
                  <p className="text-muted-foreground">Fits</p>
                  <p className="font-bold">Almost all Gen 3 & Gen 4 LS engines</p>
                  <p className="text-xs text-muted-foreground">(LS1, LS2, LS3, LS6, 4.8, 5.3, 6.0)</p>
                </div>
              </div>
              <div className="flex items-start gap-3 p-3 rounded-md bg-blue-500/10 border border-blue-500/30">
                <CheckCircle className="w-5 h-5 text-blue-500 mt-0.5 shrink-0" />
                <div>
                  <p className="font-bold text-blue-700 dark:text-blue-400">Features:</p>
                  <p className="text-sm text-muted-foreground">Rigid carrier frame prevents overtightening and squeezing the gasket out.</p>
                </div>
              </div>
              <div className="flex items-start gap-3 p-3 rounded-md bg-amber-500/10 border border-amber-500/30">
                <AlertTriangle className="w-5 h-5 text-amber-500 mt-0.5 shrink-0" />
                <div>
                  <p className="font-bold text-amber-700 dark:text-amber-400">Installation Note:</p>
                  <p className="text-sm text-muted-foreground">Install <strong>DRY</strong>. Do not add RTV to the gasket itself, only a dab in the four corners where the covers meet the block.</p>
                </div>
              </div>
              <div className="flex gap-2 mt-2">
                <PartsStoreButton partNumber="OS 30693 R" store="Summit" />
              </div>
            </CardContent>
          </Card>

          {/* Timing Cover Gasket Set */}
          <Card className="border-2 border-primary/20">
            <CardHeader className="pb-2 bg-muted/30">
              <CardTitle className="text-lg">2. Timing Cover Gasket Set</CardTitle>
            </CardHeader>
            <CardContent className="space-y-4 pt-4">
              <p className="text-muted-foreground">
                This kit usually includes the front cover gasket, the front crankshaft seal, and sometimes the water pump gaskets.
              </p>
              <div className="grid grid-cols-2 gap-4 text-sm">
                <div>
                  <p className="text-muted-foreground">Part Number</p>
                  <p className="font-bold font-mono text-lg">Fel-Pro TCS 45993</p>
                </div>
                <div>
                  <p className="text-muted-foreground">Fits</p>
                  <p className="font-bold">Gen 3 and Gen 4 LS engines</p>
                </div>
              </div>
              <div>
                <p className="text-muted-foreground text-sm mb-1">Includes:</p>
                <ul className="text-sm text-muted-foreground list-disc list-inside">
                  <li>Front cover gasket</li>
                  <li>Front crank seal</li>
                  <li>Water pump gaskets</li>
                </ul>
              </div>
              <div className="flex items-start gap-3 p-3 rounded-md bg-green-500/10 border border-green-500/30">
                <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 shrink-0" />
                <div>
                  <p className="font-bold text-green-700 dark:text-green-400">Tip:</p>
                  <p className="text-sm text-muted-foreground">If you are swapping cams, this is the kit you need.</p>
                </div>
              </div>
              <div className="flex gap-2 mt-2">
                <PartsStoreButton partNumber="TCS 45993" store="Summit" />
              </div>
            </CardContent>
          </Card>

          {/* Valve Cover Gaskets */}
          <Card className="border-2 border-primary/20">
            <CardHeader className="pb-2 bg-muted/30">
              <CardTitle className="text-lg">3. Valve Cover Gaskets</CardTitle>
            </CardHeader>
            <CardContent className="space-y-4 pt-4">
              <p className="text-muted-foreground">
                These are molded rubber gaskets that press into the valve cover groove.
              </p>
              <div className="grid grid-cols-2 gap-4 text-sm">
                <div>
                  <p className="text-muted-foreground">Part Number</p>
                  <p className="font-bold font-mono text-lg">Fel-Pro VS 50504 R</p>
                </div>
                <div>
                  <p className="text-muted-foreground">Fits</p>
                  <p className="font-bold">Center-bolt valve covers</p>
                  <p className="text-xs text-muted-foreground">(1999+ LS engines)</p>
                </div>
              </div>
              <div>
                <p className="text-muted-foreground text-sm mb-1">Includes:</p>
                <ul className="text-sm text-muted-foreground list-disc list-inside">
                  <li>Two valve cover gaskets</li>
                  <li>Rubber grommets for the bolts</li>
                </ul>
              </div>
              <div className="flex items-start gap-3 p-3 rounded-md bg-amber-500/10 border border-amber-500/30">
                <AlertTriangle className="w-5 h-5 text-amber-500 mt-0.5 shrink-0" />
                <div>
                  <p className="font-bold text-amber-700 dark:text-amber-400">Note:</p>
                  <p className="text-sm text-muted-foreground"><strong>Replace the grommets!</strong> Old, hard grommets are a common source of leaks because they don't apply proper downward pressure on the cover.</p>
                </div>
              </div>
              <div className="flex gap-2 mt-2">
                <PartsStoreButton partNumber="VS 50504 R" store="Summit" />
              </div>
            </CardContent>
          </Card>

          {/* Bonus: Snap-Up Tools */}
          <Card className="border-2 border-amber-500/50 bg-amber-500/5">
            <CardHeader className="pb-2">
              <CardTitle className="text-lg flex items-center gap-2">
                <span className="text-amber-500">★</span>
                Bonus: The "Snap-Up" Tools
              </CardTitle>
            </CardHeader>
            <CardContent className="space-y-4 pt-4">
              <p className="text-muted-foreground">
                If you are installing the oil pan while the engine is in the car (fighting gravity), these alignment tools are a lifesaver.
              </p>
              <div>
                <p className="text-muted-foreground text-sm">Part Number</p>
                <p className="font-bold font-mono text-lg">Fel-Pro ES 72863</p>
              </div>
              <div className="flex items-start gap-3 p-3 rounded-md bg-green-500/10 border border-green-500/30">
                <CheckCircle className="w-5 h-5 text-green-500 mt-0.5 shrink-0" />
                <div>
                  <p className="font-bold text-green-700 dark:text-green-400">What they do:</p>
                  <p className="text-sm text-muted-foreground">Plastic studs that hold the gasket and pan in place so you can hand-start the bolts without swearing.</p>
                </div>
              </div>
              <div className="flex gap-2 mt-2">
                <PartsStoreButton partNumber="ES 72863" store="Summit" />
              </div>
            </CardContent>
          </Card>
        </section>

        {/* Future Affiliate Note */}
        <Card className="border-2 border-dashed border-border/50 bg-muted/10">
          <CardContent className="pt-6 flex items-start gap-4">
            <AlertTriangle className="w-6 h-6 text-muted-foreground mt-1 shrink-0" />
            <div>
              <h3 className="font-bold text-base text-muted-foreground">More Products Coming Soon</h3>
              <p className="text-sm text-muted-foreground mt-1">
                Additional recommended products including coolants, bearing manufacturers, and more will be added to this section.
              </p>
            </div>
          </CardContent>
        </Card>
      </div>
    </Layout>
  );
}
