"use strict";
exports.ta = void 0;
var _index = require("./ta/_lib/formatDistance.cjs");
var _index2 = require("./ta/_lib/formatLong.cjs");
var _index3 = require("./ta/_lib/formatRelative.cjs");
var _index4 = require("./ta/_lib/localize.cjs");
var _index5 = require("./ta/_lib/match.cjs");

/**
 * @category Locales
 * @summary Tamil locale (India).
 * @language Tamil
 * @iso-639-2 tam
 * @author Sibiraj [@sibiraj-s](https://github.com/sibiraj-s)
 */
const ta = (exports.ta = {
  code: "ta",
  formatDistance: _index.formatDistance,
  formatLong: _index2.formatLong,
  formatRelative: _index3.formatRelative,
  localize: _index4.localize,
  match: _index5.match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
});
